using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Krzysztof Dobranowski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>01/15/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// AuditTrail data access layer class.
	///</summary>

	#endregion
	
	public class AuditTrail
	{

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3938"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3939"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for patient
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetPatientAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditPatient.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditPatient.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditPatient.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditPatient.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3940"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3941"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for transfusion requirements
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetTRAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditTR.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditTR.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditTR.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditTR.StoredProcName, prms).Tables[0];
		}



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7400"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7401"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for special instructions
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataTable GetSIAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditSI.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditSI.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditSI.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditSI.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3942"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3943"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for blood unit finance
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitFinanceAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnitFinance.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitFinance.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitFinance.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnitFinance.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3944"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3945"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for local Shipper
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetLocalSupplierAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditLocalSupplier.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditLocalSupplier.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditLocalSupplier.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditLocalSupplier.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3946"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3947"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for product Shipper
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetProductShipperAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditProductShipper.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditProductShipper.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditProductShipper.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditProductShipper.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3948"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audted data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3949"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for blood product
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodProductAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodProduct.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodProduct.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodProduct.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodProduct.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3950"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3951"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for HCPCS codes
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetHcpcsAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditHcpcs.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditHcpcs.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditHcpcs.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditHcpcs.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3952"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3953"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for division maintenance
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetDivisionAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditDivision.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditDivision.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditDivision.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditDivision.StoredProcName, prms).Tables[0];
		}

		/// <summary>
		/// Gets the audited data for associated institution
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetAssociatedInstitutionAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditAssociatedInstitution.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditAssociatedInstitution.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditAssociatedInstitution.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditAssociatedInstitution.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3954"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3955"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for division maintenance
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetProductModificationParameterAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditProductModificationParameter.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditProductModificationParameter.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditProductModificationParameter.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditProductModificationParameter.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3956"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3957"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for antibodies
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetAntibodyAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditAntibody.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditAntibody.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditAntibody.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditAntibody.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3958"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3959"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for workloads
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetWorkloadAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditWorkload.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditWorkload.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditWorkload.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditWorkload.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3960"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3961"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for MSBOS
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetMsbosAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditMsbos.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditMsbos.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditMsbos.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditMsbos.StoredProcName, prms).Tables[0];
		}
 
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3962"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3963"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for MSBOS Component Class
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetMsbosComponentClassAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditMsbosComponentClass.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditMsbosComponentClass.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditMsbosComponentClass.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditMsbosComponentClass.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3964"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3965"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Transfusion Effectivness
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetTransfusionEffectivenessAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditTransfusionEffectiveness.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditTransfusionEffectiveness.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditTransfusionEffectiveness.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditTransfusionEffectiveness.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3966"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3967"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Transfusion Complications
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetTransfusionComplicationsAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditTransfusionComplications.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditTransfusionComplications.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditTransfusionComplications.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditTransfusionComplications.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3968"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3969"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Inappropriate Request Indicators
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetInappropriateRequestIndicatorsAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditInappropriateRequestIndicators.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditInappropriateRequestIndicators.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditInappropriateRequestIndicators.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditInappropriateRequestIndicators.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3970"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3971"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Component Class
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetComponentClassAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditComponentClass.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditComponentClass.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditComponentClass.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditComponentClass.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3972"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3973"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Daily Control
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetDailyControlAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditDailyControl.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditDailyControl.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditDailyControl.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditDailyControl.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3974"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3975"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Reagent Test Parameter
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetReagentTestParameterAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditReagentTestParameter.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditReagentTestParameter.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditReagentTestParameter.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditReagentTestParameter.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3976"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3977"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Configure Testing
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetConfigureTestingAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditConfigureTesting.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditConfigureTesting.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditConfigureTesting.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditConfigureTesting.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3978"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3979"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Reagent Type Parameter
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetReagentTypeParameterAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditReagentTypeParameter.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditReagentTypeParameter.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditReagentTypeParameter.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditReagentTypeParameter.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3980"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3981"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for User Alerts
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetUserAlertsAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditUserAlerts.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditUserAlerts.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditUserAlerts.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditUserAlerts.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3982"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3983"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Blood Unit Status
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitStatusAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnitStatus.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitStatus.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitStatus.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnitStatus.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3984"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3985"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Blood Unit
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnit.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnit.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnit.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnit.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7404"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7405"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Blood Unit Modification
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitModificationAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnitModification.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitModification.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitModification.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnitModification.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3986"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3987"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Blood Unit Media
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitMediaAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnitMedia.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitMedia.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitMedia.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnitMedia.StoredProcName, prms).Tables[0];
		}
 
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3988"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3989"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Blood Unit Antigen
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitAntigenAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnitAntigen.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitAntigen.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitAntigen.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnitAntigen.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3990"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3991"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Blood Unit Test
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetBloodUnitTestAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditBloodUnitTest.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitTest.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditBloodUnitTest.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditBloodUnitTest.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3992"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3993"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for User Role
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetUserRoleAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditUserRole.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditUserRole.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditUserRole.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditUserRole.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3994"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3995"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for Interface Control
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetInterfaceControlAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditInterfaceControl.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditInterfaceControl.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditInterfaceControl.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditInterfaceControl.StoredProcName, prms).Tables[0];
		}
 
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7410"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7411"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the audited data for VistALink Control
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetVistALinkControlAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditVistALinkControl.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditVistALinkControl.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditVistALinkControl.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditVistALinkControl.StoredProcName, prms).Tables[0];
		}
 
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4526"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4527"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the audited data for specimen test
		/// </summary>
		/// <prmsam name="startDate"></prmsam>
		/// <prmsam name="endDate"></prmsam>
		/// <returns></returns>
		public static DataTable GetSpecimenTestAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditSpecimenTest.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditSpecimenTest.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditSpecimenTest.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditSpecimenTest.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7416"> 
		///		<ExpectedInput>Valid dates</ExpectedInput>
		///		<ExpectedOutput>DataTable containing audited data</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7417"> 
		///		<ExpectedInput>Invalid dates</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get the audited data for user
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataTable GetUserAudit(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetAuditUser.startdate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditUser.enddate, SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetAuditUser.divisioncode, SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetAuditUser.StoredProcName, prms).Tables[0];
		}
	}
}
